<?php 
/**
 * The Custom Style for Picart
 *
 * Loads the dynamically generated Css in the header of the template.
 *
 * @package Picart
 * 
 * @since pickart 1.0
 */
?>
<?php function complete_dynamic_css() { ?>
<?php global $picart; ?>
<style type="text/css">

/*Fixed Background*/
<?php if(!empty($picart['background_fixed'])){ echo 'html body.custom-background{ background-attachment:fixed;}';} ?>

/*BOXED LAYOUT*/
.site_boxed .layer_wrapper, body.home.site_boxed #slidera {width: <?php echo $picart['center_width']; ?>%;float: left;margin: 0 <?php $centerwidth = $picart['center_width']; echo (100- $centerwidth)/2; ?>%;
background: <?php echo $picart['content_bg_color']; ?>;}
.site_boxed .stat_bg, .site_boxed .stat_bg_overlay{width: <?php echo $picart['center_width']; ?>%;}
.site_boxed .social_buttons{background: <?php echo $picart['content_bg_color']; ?>;}
.site_boxed .center {width: 95%!important;margin: 0 auto;}
.site_boxed .head_top .center{ width:95%!important;}
/*Site Content Text Style*/
<?php $content_font = $picart['content_font_id']; ?>
body, input, textarea{ 
<?php if(!empty($content_font['font-family'])){ ?>font-family:<?php echo $content_font['font-family']; ?>; <?php } ?>
<?php if(!empty($content_font['font-size'])){ ?>font-size:<?php echo $content_font['font-size']; ?>; <?php } ?>
}
.single_post .single_post_content .tabs li a:link, .single_post .single_post_content .tabs li a:visited{ color:<?php echo $picart['primtxt_color_id']; ?>;}
<?php if ( is_page()) { ?>
.page_head{ background:<?php echo $picart['page_header_color']; ?>; color:<?php echo $picart['page_header_txtcolor']; ?>;}
.page_head .postitle{color:<?php echo $picart['page_header_txtcolor']; ?>;}	
.page_head .layerbread a:link, .page_head .layerbread a:visited{color:<?php echo $picart['page_header_txtcolor']; ?>;}	
.page_head_bg{background:url(<?php echo $picart['pageheader_bg_image'] ?>);}
<?php } ?>
<?php if ( is_single() || is_category() || is_archive() || is_tag() || is_author() || (get_post_type() == 'product') ) { ?>
.post_head, .author_div{ background:<?php echo $picart['post_header_color']; ?>;}
.post_head_bg, .author_div_bg{background:url(<?php echo $picart['postheader_bg_image'] ?>);}
<?php } ?>
/*Feattured Boxes Section*/
.featured_area_bg{background:url(<?php echo $picart['homeblock_bg_setting'] ?>);}
.featured_area{background-color:<?php echo $picart['homeblock_color_id'] ?>;}
.featured_block img{height:<?php echo $picart['featured_image_height'] ?>; width:<?php echo $picart['featured_image_width'] ?>} 
.boxbg1{background-color:<?php echo $picart['featured_block_bg1'] ?>;}
.boxbg2{background-color:<?php echo $picart['featured_block_bg2'] ?>;}
.boxbg3{background-color:<?php echo $picart['featured_block_bg3'] ?>;}
.boxbg4{background-color:<?php echo $picart['featured_block_bg4'] ?>;}
.featured_block h3, .featured_block h3 a, .featured_block p{color:<?php echo $picart['featured_block_color'] ?>;}
.featured_block h3:after{border-bottom-color:<?php echo $picart['featured_block_color'] ?>;}
.sktmore{background-color:<?php echo $picart['featured_block_button_bg'] ?>;}
.sktmore:hover{background-color:<?php echo $picart['featured_block_hover_button_bg'] ?>;}
/*Home Section 1*/
.home1_section_area{background-color:<?php echo $picart['section1_bgcolor_id'] ?>;}
.home1_section_area_bg{background:url(<?php echo $picart['section1_bg_image'] ?>);}
/*Home Section 2*/
.home2_section_area{background-color:<?php echo $picart['section2_bgcolor_id'] ?>;}
.home2_section_area_bg{background:url(<?php echo $picart['section2_bg_image'] ?>);}
/*Home Section 3*/
.home3_section_area{background-color:<?php echo $picart['section3_bgcolor_id'] ?>;}
.home3_section_area_bg{background:url(<?php echo $picart['section3_bg_image'] ?>);}
/*Home Section 4*/
.home4_section_area{background-color:<?php echo $picart['section4_bgcolor_id'] ?>;}
.home4_section_area_bg{background:url(<?php echo $picart['section4_bg_image'] ?>);}
/*Home Section 5*/
.home5_section_area{background-color:<?php echo $picart['section5_bgcolor_id'] ?>;}
.home5_section_area_bg{background:url(<?php echo $picart['section5_bg_image'] ?>);}
/*Home Section 6*/
.home6_section_area{background-color:<?php echo $picart['section6_bgcolor_id'] ?>;}
.home6_section_area_bg{background:url(<?php echo $picart['section6_bg_image'] ?>);}
/*Home Section 7*/
.home7_section_area{background-color:<?php echo $picart['section7_bgcolor_id'] ?>;}
.home7_section_area_bg{background:url(<?php echo $picart['section7_bg_image'] ?>);}
/*Home Section 8*/
.home8_section_area{background-color:<?php echo $picart['section8_bgcolor_id'] ?>;}
.home8_section_area_bg{background:url(<?php echo $picart['section8_bg_image'] ?>);}
/*Home Section 9*/
.home9_section_area{background-color:<?php echo $picart['section9_bgcolor_id'] ?>;}
.home9_section_area_bg{background:url(<?php echo $picart['section9_bg_image'] ?>);}
/*Home Section 10*/
.home10_section_area{background-color:<?php echo $picart['section10_bgcolor_id'] ?>;}
.home10_section_area_bg{background:url(<?php echo $picart['section10_bg_image'] ?>);}
/*Home Section 11*/
.home11_section_area{background-color:<?php echo $picart['section11_bgcolor_id'] ?>;}
.home11_section_area_bg{background:url(<?php echo $picart['section11_bg_image'] ?>);}
/*-----------------------------COLORS------------------------------------*/
/*Header Color*/
.header{ position:relative!important; background-color: rgba(<?php echo complete_hex2rgb($picart['head_color_id']);?>, <?php if(empty($picart['head_transparent'])){ echo '1'; }else { echo $picart['head_bg_trans'];} ?>);}
.page .header, .single .header, .archive .header, .search .header{ position:relative!important; background-color: rgba(<?php echo complete_hex2rgb($picart['head_color_id']);?>, 1)!important;}
<?php if('noslider' == $picart['slider_type_id']){ ?>
/*Header Color*/
body .header{ position:relative!important; background:<?php echo $picart['head_color_id']; ?>;}
.page #slidera, .single #slidera, .archive #slidera, .search #slidera, .error404 #slidera{ height:auto!important;}
<?php } ?>
/*Head Top Bar Color*/
.head-info-area{background:<?php echo $picart['head_info_color_id']; ?>;}
<?php if(!empty($picart['head_transparent'])){ ?>
.home.has_trans_header .header_wrap {float: left; position:relative;width: 100%;}
.home.has_trans_header .header{position: absolute!important;z-index: 999;}
/*Boxed Header should have boxed width*/
body.home.site_boxed .header_wrap.layer_wrapper{width: <?php echo $picart['center_width']; ?>%;float: left;margin: 0 <?php $centerwidth = $picart['center_width']; echo (100- $centerwidth)/2; ?>%;}
.home.has_trans_header .header, .home.has_trans_header.page.page-template-page-frontpage_template .header{background-image:none;}
		<?php } ?>
		.home.has_trans_header.page .header{background:<?php echo $picart['head_color_id']; ?>!important;}
		@media screen and (max-width: 480px){
		.home.has_trans_header .header{ background:<?php echo $picart['head_color_id']; ?>!important;}
		}
		/*LOGO*/
		.logo img{height:<?php echo $picart['logo_image_height'] ?>; width:<?php echo $picart['logo_image_width'] ?>; margin-top:<?php echo $picart['logo_margin_top'] ?>;} 

		<?php $logofont = $picart['logo_font_id']; ?>
		.logo h2, .logo h1, .logo h2 a:link, .logo h2 a:visited, .logo h1 a:link, .logo h1 a:visited, .logo h2 a:hover, .logo h1 a:hover{ 
			<?php if(!empty($logofont['font-family'])){ ?>font-family:'<?php echo $logofont['font-family']; ?>'; <?php } ?>
			<?php if(!empty($logofont['font-size'])){ ?>font-size:<?php echo $logofont['font-size']; ?>;<?php } ?>
			color:<?php echo $picart['logo_color_id']; ?>;
		}
		/*HEADER TEXT BAR*/
		<?php $tpbtfont = $picart['tpbt_font_id']; ?>
		.head-info-area, .head-info-area a:link, .head-info-area a:visited, .leftpart, .leftpart a:link, .leftpart a:visited, .rightpart, .rightpart a:link, .rightpart a:visited{ 
			<?php if(!empty($tpbtfont['font-family'])){ ?>font-family:'<?php echo $tpbtfont['font-family']; ?>'; <?php } ?>
			<?php if(!empty($tpbtfont['font-size'])){ ?>font-size:<?php echo $tpbtfont['font-size']; ?>;<?php } ?>
			color:<?php echo $picart['tpbt_color_id']; ?>;
		}	

		.head-info-area a:hover, .leftpart a:hover, .rightpart a:hover{ 
			color:<?php echo $picart['tpbt_hvcolor_id']; ?>;
		}		
		
		a:link, a:visited{color:<?php echo $picart['global_link_color_id']; ?>;}
		a:hover{color:<?php echo $picart['global_link_hvcolor_id']; ?>;}
		
		
		/*Slider Title*/
		<?php $sldttlefont = $picart['sldtitle_font_id']; ?>
		.title{ 
			<?php if(!empty($sldttlefont['font-family'])){ ?>font-family:'<?php echo $sldttlefont['font-family']; ?>'; <?php } ?>
			<?php if(!empty($sldttlefont['font-size'])){ ?>font-size:<?php echo $sldttlefont['font-size']; ?>;<?php } ?>
			color:<?php echo $picart['slidetitle_color_id']; ?>; background-color:<?php echo $picart['slidetitle_bg_color']; ?>;
		}	
		
		<?php $slddescfont = $picart['slddesc_font_id']; ?>
		.slidedesc{ 
			<?php if(!empty($slddescfont['font-family'])){ ?>font-family:'<?php echo $slddescfont['font-family']; ?>'; <?php } ?>
			<?php if(!empty($slddescfont['font-size'])){ ?>font-size:<?php echo $slddescfont['font-size']; ?>;<?php } ?>
			color:<?php echo $picart['slddesc_color_id']; ?>;
		}	
		
		<?php $sldbtn = $picart['sldbtn_font_id']; ?>
		.slidebtn{ 
			<?php if(!empty($sldbtn['font-family'])){ ?>font-family:'<?php echo $sldbtn['font-family']; ?>'; <?php } ?>
			<?php if(!empty($sldbtn['font-size'])){ ?>font-size:<?php echo $sldbtn['font-size']; ?>;<?php } ?>;
		}
		.slidebtn a{ 
			color:<?php echo $picart['sldbtntext_color_id']; ?>; background-color:<?php echo $picart['sldbtn_color_id']; ?>;
		}	
		.slidebtn a:hover{background-color:<?php echo $picart['sldbtn_hvcolor_id']; ?>}	
		.nivo-controlNav a{background-color:<?php echo $picart['slide_pager_color_id']; ?>}
		.nivo-controlNav a.active{background-color:<?php echo $picart['slide_active_pager_color_id']; ?>}	
		
		.theme-default .nivo-directionNav a{background-color: rgba(<?php echo complete_hex2rgb($picart['pagination_bg_color']);?>, <?php echo $picart['pagination_trans']; ?>);}			
		
		
		/* Global H1 */	
				<?php $global_h1_font = $picart['global_h1_font_id']; ?>
		h1, h1 a:link, h1 a:visited{ 
			<?php if(!empty($global_h1_font['font-family'])){ ?>font-family:'<?php echo $global_h1_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h1_font['font-size'])){ ?>font-size:<?php echo $global_h1_font['font-size']; ?>;<?php } ?>
			color:<?php echo $picart['global_h1_color_id']; ?>;
		}
		
		h1 a:hover{ 
			color:<?php echo $picart['global_h1_hvcolor_id']; ?>;
		}
		
		/* Global H2 */	
				<?php $global_h2_font = $picart['global_h2_font_id']; ?>
		h2, h2 a:link, h2 a:visited{ 
			<?php if(!empty($global_h2_font['font-family'])){ ?>font-family:'<?php echo $global_h2_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h2_font['font-size'])){ ?>font-size:<?php echo $global_h2_font['font-size']; ?>;<?php } ?>
		color:<?php echo $picart['global_h2_color_id']; ?>;
		}
		
		h2 a:hover{ 
			color:<?php echo $picart['global_h2_hvcolor_id']; ?>;
		}
		
		/* Global H3 */	
				<?php $global_h3_font = $picart['global_h3_font_id']; ?>
		h3, h3 a:link, h3 a:visited{ 
			<?php if(!empty($global_h3_font['font-family'])){ ?>font-family:'<?php echo $global_h3_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h3_font['font-size'])){ ?>font-size:<?php echo $global_h3_font['font-size']; ?>;<?php } ?>
		color:<?php echo $picart['global_h3_color_id']; ?>;
		}
		
		h3 a:hover{ 
			color:<?php echo $picart['global_h3_hvcolor_id']; ?>;
		}
		
		/* Global H4 */	
				<?php $global_h4_font = $picart['global_h4_font_id']; ?>
		h4, h4 a:link, h4 a:visited{ 
			<?php if(!empty($global_h4_font['font-family'])){ ?>font-family:'<?php echo $global_h4_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h4_font['font-size'])){ ?>font-size:<?php echo $global_h4_font['font-size']; ?>;<?php } ?>
		color:<?php echo $picart['global_h4_color_id']; ?>;
		}
		
		h4 a:hover{ 
			color:<?php echo $picart['global_h4_hvcolor_id']; ?>;
		}	
		
		/* Global H5 */	
				<?php $global_h5_font = $picart['global_h5_font_id']; ?>
		h5, h5 a:link, h5 a:visited{ 
			<?php if(!empty($global_h5_font['font-family'])){ ?>font-family:'<?php echo $global_h5_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h5_font['font-size'])){ ?>font-size:<?php echo $global_h5_font['font-size']; ?>;<?php } ?>
		color:<?php echo $picart['global_h5_color_id']; ?>;
		}
		
		h5 a:hover{ 
			color:<?php echo $picart['global_h5_hvcolor_id']; ?>;
		}	
		
		.cols1:hover h5 a, .cols2:hover h5 a, .cols3:hover h5 a, .cols4:hover h5 a, .cols5:hover h5 a, .cols6:hover h5 a{color:<?php echo $picart['team_box_color_id']; ?>;}
		
		/* Global H6 */	
				<?php $global_h6_font = $picart['global_h6_font_id']; ?>
		h6, h6 a:link, h6 a:visited{ 
			<?php if(!empty($global_h6_font['font-family'])){ ?>font-family:'<?php echo $global_h6_font['font-family']; ?>'; <?php } ?>
			<?php if(!empty($global_h6_font['font-size'])){ ?>font-size:<?php echo $global_h6_font['font-size']; ?>;<?php } ?>
		color:<?php echo $picart['global_h6_color_id']; ?>;
		}
		
		h6 a:hover{ 
			color:<?php echo $picart['global_h6_hvcolor_id']; ?>;
		}
		
		/* Post Meta Color */
		.post_block_style1_meta, .post_block_style1_meta a:link, .post_block_style1_meta a:visited, .post_block_style2_meta, .post_block_style2_meta a:link, .post_block_style2_meta a:visited, .single_metainfo, .single_metainfo a:link, .single_metainfo a:visited{ 
			color:<?php echo $picart['post_meta_color_id']; ?>;
		}
		
		/* Team Thumb Hover Background Color */
		.team-thumb{ 
			background-color:<?php echo $picart['team_box_color_id']; ?>;
		}
		
		/* Social Icon Background Color */
		.social-icons a:link, .social-icons a:visited{ 
			background-color:<?php echo $picart['social_icon_color_id']; ?>;
			color:<?php echo $picart['social_text_color_id']; ?>;
		}	
		
		/* Social Icon Hover Background Color */
		.social-icons a:hover{ 
			background-color:<?php echo $picart['social_hover_icon_color_id']; ?>;
			color:<?php echo $picart['social_text_hover_color_id']; ?>;
		}
		
		/* Teambox Background Color */
		.testimonial-box, .itembox{ 
			background-color:<?php echo $picart['testimonialbox_color_id']; ?> !important;
		}	
		.testimonial-box:after, .itembox::after{ 
			border-top-color:<?php echo $picart['testimonialbox_color_id']; ?>;
			border-color: <?php echo $picart['testimonialbox_color_id']; ?> transparent transparent;
		}	
		
		/* Pager Color */
		.bx-wrapper .bx-pager.bx-default-pager a:link, .bx-wrapper .bx-pager.bx-default-pager a:visited{ 
			background:<?php echo $picart['testimonial_pager_color_id']; ?>;
		}	
		
		/* Pager Active Color */
		.bx-wrapper .bx-pager.bx-default-pager a:hover, .bx-wrapper .bx-pager.bx-default-pager a.active{ 
			background:<?php echo $picart['testimonial_activepager_color_id']; ?>;
		}
		.itembox, .bxslider li{
			color:<?php echo $picart['testimonial_txt_color']; ?> !important;
		}
		/* Gallery Filter Active Bgcolor */
		li.active a:link, li.active a:visited{ 
			background-color:<?php echo $picart['gallery_filter_color_id']; ?>;
			color:<?php echo $picart['gallery_activefiltertxt_color_id']; ?> !important;
		}	
		
		.filter_padder{
			background-color:<?php echo $picart['grid_filter_bg']; ?>;
		}
		
		.filter:hover, .filter.selected{
			color:<?php echo $picart['grid_filter_active_color']; ?>;
		}
		
		.filter{
			color:<?php echo $picart['grid_filter_color']; ?>;
		}
		
		.mega-hover{background-color: rgba(<?php echo complete_hex2rgb($picart['grid_image_hover_color']);?>, 0.8);}
		
		/* Gallery Filter Active Bgcolor */
		.portfolio-categ li a:link, .portfolio-categ li a:visited{ 
			color:<?php echo $picart['gallery_filtertxt_color_id']; ?>;
		}			
		
		/* Skills Bar Background Color */
		.skill-bg{ 
			background-color:<?php echo $picart['skillsbar_bgcolor_id']; ?>;
		}	
		
		/* Skills Bar Text Color */
		.skillbar-title{ 
			color:<?php echo $picart['skillsbar_text_color_id']; ?>;
		}			
															
		#simple-menu{color:<?php echo $picart['menutxt_color_id']; ?>;}
		body.home.has_trans_header #simple-menu{color:<?php echo $picart['trans_header_color']; ?>;}
		span.desc{color:<?php echo $picart['logo_color_id']; ?>;}

		/*MENU Text Color*/
		.menubarbg{background-color:<?php echo $picart['menu_bar_bg_color'] ?>;}
		#topmenu ul li, #topmenu ul li ul li{border-color:<?php echo $picart['menu_border_color'] ?>;}
		#topmenu ul li a:link, #topmenu ul li a:visited{color:<?php echo $picart['menutxt_color_id'] ?>;}
		#topmenu ul li.menu_hover a:link, #topmenu ul li.menu_hover a:visited{border-color:<?php echo $picart['menutxt_color_hover']; ?>;}
		#topmenu ul li.menu_hover>a:link, #topmenu ul li.menu_hover>a:visited, body.has_trans_header.home #topmenu ul li.menu_hover>a:link, body.has_trans_header.home #topmenu ul li.menu_hover>a:visited{color:<?php echo $picart['menutxt_color_hover'] ?>;}
		#topmenu ul li.current-menu-item>a:link, #topmenu ul li.current-menu-item>a:visited, #topmenu ul li.current-menu-parent>a:link, #topmenu ul li.current_page_parent>a:visited, #topmenu ul li.current-menu-ancestor>a:link, #topmenu ul li.current-menu-ancestor>a:visited{color:<?php echo $picart['menutxt_color_active'] ?>;}
		#topmenu ul li ul{border-color:<?php echo $picart['menutxt_color_hover']; ?> transparent transparent transparent;}
		#topmenu ul.menu>li:hover:after{background-color:<?php echo $picart['menutxt_color_hover']; ?>;}
		#topmenu ul li ul li a:hover{color:<?php echo $picart['menutxt_color_active']; ?>;}
		
		#topmenu .menu_hover > a:link, #topmenu .menu_hover > a:visited, #topmenu ul li.current-menu-item>a:link, #topmenu ul li.current-menu-item>a:visited, #topmenu ul li.current-menu-parent>a:link, #topmenu ul li.current_page_parent>a:visited, #topmenu ul li.current-menu-ancestor>a:link, #topmenu ul li.current-menu-ancestor>a:visited{ background-color:<?php echo $picart['mnbg_color_id']; ?>}
		
		#topmenu ul.menu ul li{background-color:<?php echo $picart['submnbg_color_id']; ?>;}		
		
		#topmenu ul.sub-menu li a, #topmenu ul.children li a{color:<?php echo $picart['submnu_textcolor_id']; ?>;}	
		#topmenu ul.sub-menu li a:hover, #topmenu ul.children li a:hover, #topmenu li.menu_highlight_slim:hover, #topmenu ul.sub-menu li.current_page_item a, #topmenu ul.children li.current_page_item a, #topmenu ul.sub-menu li.current-menu-item a, #topmenu ul.children li.current-menu-item a{background-color:<?php echo $picart['mnshvr_color_id']; ?> !important;}	

		.sidr{ background-color:<?php echo $picart['mobbg_color_id']; ?>;}
		.pad_menutitle{ background-color:<?php echo $picart['mobbgtop_color_id']; ?>;}
		.sidr ul li a, .sidr ul li span, .sidr ul li ul li a, .sidr ul li ul li span{color:<?php echo $picart['mobmenutxt_color_id']; ?>;}	
		
		#simple-menu .fa-bars{color:<?php echo $picart['mobtoggle_color_id']; ?> !important;}
		.pad_menutitle .fa-bars, .pad_menutitle .fa-times{color:<?php echo $picart['mobtoggleinner_color_id']; ?> !important;}				

		.head_soc .social_bookmarks a:link, .head_soc .social_bookmarks a:visited{color:<?php echo $picart['menutxt_color_id'] ?>;}
		.head_soc .social_bookmarks.bookmark_hexagon a:before {border-bottom-color: rgba(<?php echo complete_hex2rgb($picart['menutxt_color_id']);?>, 0.3)!important;}
		.head_soc .social_bookmarks.bookmark_hexagon a i {background:rgba(<?php echo complete_hex2rgb($picart['menutxt_color_id']);?>, 0.3)!important;}
		.head_soc .social_bookmarks.bookmark_hexagon a:after { border-top-color:rgba(<?php echo complete_hex2rgb($picart['menutxt_color_id']);?>, 0.3)!important;}
		

<?php if($picart['sec_color_id']){ ?>
		/*BASE Color*/
		.widget_border, .heading_border, #wp-calendar #today, .thn_post_wrap .more-link:hover, .moretag:hover, .search_term #searchsubmit, .error_msg #searchsubmit, #searchsubmit, .complete_pagenav a:hover, .nav-box a:hover .left_arro, .nav-box a:hover .right_arro, .pace .pace-progress, .homeposts_title .menu_border, span.widget_border, .ast_login_widget #loginform #wp-submit, .prog_wrap, .lts_layout1 a.image, .lts_layout2 a.image, .lts_layout3 a.image, .rel_tab:hover .related_img, .wpcf7-submit, .woo-slider #post_slider li.sale .woo_sale, .nivoinner .slide_button_wrap .lts_button, #accordion .slide_button_wrap .lts_button, .img_hover, p.form-submit #submit, .optimposts .type-product a.button.add_to_cart_button{background:<?php echo $picart['sec_color_id'] ?>;} 
		
		.share_active, .comm_auth a, .logged-in-as a, .citeping a, .lay3 h2 a:hover, .lay4 h2 a:hover, .lay5 .postitle a:hover, .nivo-caption p a, .acord_text p a, .org_comment a, .org_ping a, .contact_submit input:hover, .widget_calendar td a, .ast_biotxt a, .ast_bio .ast_biotxt h3, .lts_layout2 .listing-item h2 a:hover, .lts_layout3 .listing-item h2 a:hover, .lts_layout4 .listing-item h2 a:hover, .lts_layout5 .listing-item h2 a:hover, .rel_tab:hover .rel_hover, .post-password-form input[type~=submit], .bio_head h3, .blog_mo a:hover, .ast_navigation a:hover, .lts_layout4 .blog_mo a:hover{color:<?php echo $picart['sec_color_id'] ?>;}
		#home_widgets .widget .thn_wgt_tt, #sidebar .widget .thn_wgt_tt, #footer .widget .thn_wgt_tt, .astwt_iframe a, .ast_bio .ast_biotxt h3, .ast_bio .ast_biotxt a, .nav-box a span, .lay2 h2.postitle:hover a{color:<?php echo $picart['sec_color_id'] ?>;}
		.pace .pace-activity{border-top-color: <?php echo $picart['sec_color_id']; ?>!important;border-left-color: <?php echo $picart['sec_color_id']; ?>!important;}
		.pace .pace-progress-inner{box-shadow: 0 0 10px <?php echo $picart['sec_color_id'] ?>, 0 0 5px <?php echo $picart['sec_color_id']; ?>;
		  -webkit-box-shadow: 0 0 10px <?php echo $picart['sec_color_id'] ?>, 0 0 5px <?php echo $picart['sec_color_id']; ?>;
		  -moz-box-shadow: 0 0 10px <?php echo $picart['sec_color_id'] ?>, 0 0 5px <?php echo $picart['sec_color_id']; ?>;}
		
		.fotorama__thumb-border, .ast_navigation a:hover{ border-color:<?php echo $picart['sec_color_id'] ?>!important;}
		
		
		/*Text Color on BASE COLOR Element*/
		.icon_round a, #wp-calendar #today, .moretag:hover, .search_term #searchsubmit, .error_msg #searchsubmit, .complete_pagenav a:hover, .ast_login_widget #loginform #wp-submit, #searchsubmit, .prog_wrap, .rel_tab .related_img i, .lay1 h2.postitle a, .nivoinner .slide_button_wrap .lts_button, #accordion .slide_button_wrap .lts_button, .lts_layout1 .icon_wrap a, .lts_layout2 .icon_wrap a, .lts_layout3 .icon_wrap a, .lts_layout1 .icon_wrap a:hover{color:<?php echo $picart['sectxt_color_id']; ?>;}
		.thn_post_wrap .listing-item .moretag:hover, body .lts_layout1 .listing-item .title, .lts_layout2 .img_wrap .complete_plus, .img_hover .icon_wrap a, body .thn_post_wrap .lts_layout1 .icon_wrap a, .wpcf7-submit, .woo-slider #post_slider li.sale .woo_sale, p.form-submit #submit, .optimposts .type-product a.button.add_to_cart_button{color:<?php echo $picart['sectxt_color_id']; ?>;}

<?php } ?>



/*Sidebar Widget Background Color */
#sidebar .widget{ background:<?php echo $picart['sidebar_color_id']; ?>;}
#sidebar .widget_wrap{border-color:<?php echo $picart['sidebarborder_color_id']; ?>;}
/*Widget Title Color */
#sidebar .widget-title, #sidebar .widget-title a{color:<?php echo $picart['sidebar_tt_color_id'] ?>;}

#sidebar #sidebar .widget, #sidebar .widget .widget_wrap{ color:<?php echo $picart['sidebartxt_color_id'] ?>;}
#sidebar .widget .widgettitle, #sidebar .widget .widgettitle a:link, #sidebar .widget .widgettitle a:visited{font-size:<?php echo $picart['wgttitle_size_id']; ?>;}

#sidebar .widget li a, #sidebar .widget a{ color:<?php echo $picart['sidebarlink_color_id'] ?>;}
#sidebar .widget li a:hover, #sidebar .widget a:hover{ color:<?php echo $picart['sidebarlink_hover_color_id'] ?>;}


.flipcard .front{background-color:<?php echo $picart['flipbg_front_color_id'] ?>; border-color:<?php echo $picart['flipborder_front_color_id'] ?>;}

.flipcard .back{background-color:<?php echo $picart['flipbg_back_color_id'] ?>; border-color:<?php echo $picart['flipborder_back_color_id'] ?>;}

.divider5 span, .divider6 span{background-color:<?php echo $picart['divider_color_id'] ?>;}
.divider1, .divider2, .divider3, .divider4, .divider5, .divider6, .fusion-title .title-sep, .fusion-title.sep-underline, .product .product-border, .fusion-title .title-sep{border-color:<?php echo $picart['divider_color_id'] ?>;}

.timeline-both-side li .timeline-description{background-color:<?php echo $picart['timebox_color_id'] ?>;}

.timeline-both-side:before, .timeline-both-side li .border-line, .timeline-both-side li .border-line:before{background-color:<?php echo $picart['timeboxborder_color_id'] ?>;}

.timeline-both-side:after, .timeline-both-side li .timeline-description{border-color:<?php echo $picart['timeboxborder_color_id'] ?>;}
.griditem{background-color:<?php echo $picart['gridbox_color_id'] ?>;}
.griditem{border-color:<?php echo $picart['gridboxborder_color_id'] ?>;}
.post-lay3-box{border-color:<?php echo $picart['pstyle_gridboxborder_color_id'] ?>; background-color:<?php echo $picart['pstyle_gridbox_color_id'] ?>;}
.clientbox{border-color:<?php echo $picart['ourclient_border_color'] ?>;}
.lay3-photo-box{background-color:rgba(<?php echo complete_hex2rgb($picart['image_hover_pstyle']);?>, 1);}


<?php if($picart['footer_title_color']){ ?>
#footer .footercols1 h3, #footer .footercols2 h3, #footer .footercols3 h3, #footer .footercols4 h3{color:<?php echo $picart['footer_title_color']; ?>;}
<?php } ?>

ul.footmenu li a{color:<?php echo $picart['footer_menu_color']; ?>;}
ul.footmenu li a:hover{color:<?php echo $picart['footer_menu_hover_color']; ?>;}

<?php if($picart['footer_color_id']){ ?>
/*FOOTER WIDGET COLORS*/
#footer{background: <?php echo $picart['footer_color_id']; ?>;}
#footer .footercols1, #footer .footercols2, #footer .footercols3, #footer .footercols4, .footer-post-area ul li h4, .footer-post-area ul li h4 a:link, .footer-post-area ul li h4 a:visited{color:<?php echo $picart['footwdgtxt_color_id']; ?>;}
<?php } ?>
/*COPYRIGHT COLORS*/
#copyright{background: <?php echo $picart['copyright_bg_color']; ?>;}
.copytext, .copytext a:link, .copytext a:visited{color: <?php echo $picart['copyright_txt_color']; ?>;}

.foot_soc .social_bookmarks a:link, .foot_soc .social_bookmarks a:visited{color:<?php echo $picart['copyright_txt_color'] ?>;}
.foot_soc .social_bookmarks.bookmark_hexagon a:before {border-bottom-color: rgba(<?php echo complete_hex2rgb($picart['copyright_txt_color']);?>, 0.3);}
.foot_soc .social_bookmarks.bookmark_hexagon a i {background:rgba(<?php echo complete_hex2rgb($picart['copyright_txt_color']);?>, 0.3);}
.foot_soc .social_bookmarks.bookmark_hexagon a:after { border-top-color:rgba(<?php echo complete_hex2rgb($picart['copyright_txt_color']);?>, 0.3);}


<?php if(get_background_color() == ''){?>#frontsidebar, .fixed_wrap.fixindex.dummypost, #slidera{ background-color:#<?php echo get_background_color(); ?>;} <?php } ?>

/*-------------------------------------TYPOGRAPHY--------------------------------------*/

/*Post Titles and headings Font*/
.postitle, .product_title{ font-family:<?php echo $picart['ptitle_font_id']['font-family']; ?>;}

/*Menu Font*/
#topmenu ul li a{ font-family:<?php echo $picart['mnutitle_font_id']['font-family']; ?>;}

<?php if((!empty($picart['txt_upcase_id']))){ ?>
.midrow_block h3, .lay1 h2.postitle, .more-link, .moretag, .single_post .postitle, .related_h3, .comments_template #comments, #comments_ping, #reply-title, #submit, #sidebar .widget .widgettitle, #sidebar .widget .widgettitle a, .search_term h2, .search_term #searchsubmit, .error_msg #searchsubmit, #footer .widgets .widgettitle, .home_title, body .lts_layout1 .listing-item .title, .lay4 h2.postitle, .lay2 h2.postitle a, #home_widgets .widget .widgettitle, .product_title, .page_head h1, .featured_area h2, .featured_block h3, h1, h2, h3, h4, h5, h6{ text-transform:uppercase; letter-spacing:1px;}
<?php } ?>

<?php if((!empty($picart['mnutxt_upcase_id']))){ ?>
#topmenu ul li a{ text-transform:uppercase; letter-spacing:1px;}
<?php } ?>

#topmenu ul li a{font-size:<?php echo $picart['menu_size_id']; ?>;}
#topmenu ul li {line-height: <?php echo $picart['menu_size_id']; ?>;}

<?php if($picart['primtxt_color_id']){ ?>
/*Body Text Color*/
body, .home_cat a, .contact_submit input, .comment-form-comment textarea{ color:<?php echo $picart['primtxt_color_id']; ?>;}
.single_post_content .tabs li a{ color:<?php echo $picart['primtxt_color_id']; ?>;}
.thn_post_wrap .listing-item .moretag{ color:<?php echo $picart['primtxt_color_id']; ?>;}
<?php } ?>	
	

<?php if($picart['title_txt_color_id']){ ?>
/*Post Title */
.postitle, .postitle a, .nav-box a, h3#comments, h3#comments_ping, .comment-reply-title, .related_h3, .nocomments, .lts_layout2 .listing-item h2 a, .lts_layout3 .listing-item h2 a, .lts_layout4 .listing-item h2 a, .author_inner h5, .product_title, .woocommerce-tabs h2, .related.products h2, .optimposts .type-product h2.postitle a, .woocommerce ul.products li.product h3{ text-decoration:none; color:<?php echo $picart['title_txt_color_id'] ?>;}
<?php } ?>

/*Woocommerce*/
.optimposts .type-product a.button.add_to_cart_button:hover{background-color:<?php echo $picart['sectxt_color_id'] ?>;color:<?php echo $picart['sec_color_id']; ?>;} 
.optimposts .lay2_wrap .type-product span.price, .optimposts .lay3_wrap .type-product span.price, .optimposts .lay4_wrap  .type-product span.price, .optimposts .lay4_wrap  .type-product a.button.add_to_cart_button{color:<?php echo $picart['title_txt_color_id'] ?>;}
.optimposts .lay2_wrap .type-product a.button.add_to_cart_button:before, .optimposts .lay3_wrap .type-product a.button.add_to_cart_button:before{color:<?php echo $picart['title_txt_color_id'] ?>;}
.optimposts .lay2_wrap .type-product a.button.add_to_cart_button:hover:before, .optimposts .lay3_wrap .type-product a.button.add_to_cart_button:hover:before, .optimposts .lay4_wrap  .type-product h2.postitle a{color:<?php echo $picart['sec_color_id'] ?>;}


<?php if(!$picart['show_blog_thumb'] ) { ?>
.page-template-templatespage-blog_template-php .lay4 .post_content{width:100%;}
<?php } ?>

@media screen and (max-width: 480px){
body.home.has_trans_header .header .logo h1 a:link, body.home.has_trans_header .header .logo h1 a:visited{ color:<?php echo $picart['logo_color_id']; ?>!important;}
body.home.has_trans_header .header #simple-menu{color:<?php echo $picart['menutxt_color_id']; ?>!important;}
}

/*USER'S CUSTOM CSS---------------------------------------------------------*/
<?php if ( ! empty ( $picart['custom-css'] ) ) { ?><?php echo stripslashes($picart['custom-css']); ?><?php } ?>
/*---------------------------------------------------------*/
</style>

<!--[if IE]>
<style type="text/css">
.text_block_wrap, .home .lay1, .home .lay2, .home .lay3, .home .lay4, .home .lay5, .home_testi .looper, #footer .widgets{opacity:1!important;}
#topmenu ul li a{display: block;padding: 20px; background:url(#);}
</style>
<![endif]-->
<?php } ?>
<?php add_action( 'wp_head', 'complete_dynamic_css'); ?>