<?php
 /**
 * The CORE functions for Picart
 *
 * Stores all the core functions of the template.
 *
 * @package Picart
 * 
 * @since pickart 1.0
 */

//ADD BODY CLASSES
function complete_body_class( $classes ) {
	global $picart;
	// add classes to the $classes array
		$classes[] = ''.$picart['site_layout_id'].'';
	if(!empty($picart['head_transparent'])){
		$classes[] = 'has_trans_header';
	}
	if('site_boxed' == $picart['site_layout_id']){
		$classes[] = 'is_boxed';
	}
	if(is_rtl()){
		$classes[] = 'layer_rtl';
	}
	if ( !is_front_page() ) {
		$classes[] = 'not_frontpage';
	}
	if ( is_customize_preview() ) {
		$classes[] = 'customizer-prev';
	}

	return $classes;
}
add_filter( 'body_class', 'complete_body_class' );

	
//SIDEBAR
function complete_widgets_init(){

	$editbutton = (is_customize_preview() ? '<a class="edit_widget" title="Edit Widget - #%1$s"><i class="fa fa-pencil"></i></a>' : '');
	register_sidebar(array(
	'name'          => __('Page Sidebar', 'picart'),
	'id'            => 'sidebar-page',
	'description'   => __('When you assign widgets to this area, it will be displayed on all pages.', 'picart'),
	'before_widget' => '<div id="%1$s" class="widget %2$s" data-widget-id="%1$s"><div class="widget_wrap">'.$editbutton,
	'after_widget'  => '<span class="widget_corner"></span></div></div>',
	'before_title'  => '<h3 class="widgettitle">',
	'after_title'   => '</h3>'
	));
	
	register_sidebar(array(
	'name'          => __('Blog Sidebar', 'picart'),
	'id'            => 'sidebar-blog',
	'description'   => __('When you assign widgets to this area, it will be displayed on all posts and blog.', 'picart'),
	'before_widget' => '<div id="%1$s" class="widget %2$s" data-widget-id="%1$s"><div class="widget_wrap">'.$editbutton,
	'after_widget'  => '<span class="widget_corner"></span></div></div>',
	'before_title'  => '<h3 class="widgettitle">',
	'after_title'   => '</h3>'
	));	
 
	register_sidebar( array(
		'name'          => __( 'Header Left Widget', 'picart' ),
		'description'   => __( 'Appears on header', 'picart' ),
		'id'            => 'headerleft',
		'before_widget' => '<div class="left">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Header Right Widget', 'picart' ),
		'description'   => __( 'Appears on header', 'picart' ),
		'id'            => 'headerright',
		'before_widget' => '<div class="right">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) ); 
	
	register_sidebar( array(
		'name'          => __( 'Footer 1 Column', 'picart' ),
		'description'   => __( 'Appears on footer 1 columns', 'picart' ),
		'id'            => 'footer-1',
		'before_widget' => '<div id="%1$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 2 Columns', 'picart' ),
		'description'   => __( 'Appears on footer 2 columns', 'picart' ),
		'id'            => 'footer-2',
		'before_widget' => '<div id="%1$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 3 Columns', 'picart' ),
		'description'   => __( 'Appears on footer 3 columns', 'picart' ),
		'id'            => 'footer-3',
		'before_widget' => '<div id="%1$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 4 Columns', 'picart' ),
		'description'   => __( 'Appears on footer 4 columns', 'picart' ),
		'id'            => 'footer-4',
		'before_widget' => '<div id="%1$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );			
 	
}

add_action( 'widgets_init', 'complete_widgets_init' );


//Default Placeholder Image
function complete_placeholder_image(){
	return ''. get_template_directory_uri().'/assets/images/blank_img.png';
}

//Assign Thumbnail to post if it has gallery
function complete_gallery_thumb(){
 	global $post;
 	// Make sure the post has a gallery in it
 	if( has_shortcode( $post->post_content, 'gallery' ) ){

		$gallery = get_post_gallery( get_the_ID(), false );
		$ids = explode( ",", $gallery['ids'] );
	
		foreach( $ids as $id ) {
		   $imgurl   = wp_get_attachment_image_src( $id, array(400,270) );
		} 
	
		$first_thumb = $imgurl[0];
		return $first_thumb;
	}
 }

// force the link='file' gallery shortcode attribute:
add_filter('shortcode_atts_gallery','complete_overwrite_gallery_atts',10,3);
function complete_overwrite_gallery_atts($out, $pairs, $atts){
	global $picart;
	if(!empty($picart['post_gallery_id']))
    $out['link']='file'; 
    return $out;
}


//Display Read More Button in Layout4
function complete_excerpt_more($more) {
	return '<br><a class="moretag" href="'. get_permalink() . '">'.__('+ Read More', 'picart').'</a>';
}
add_filter('excerpt_more', 'complete_excerpt_more');


//Alter the Read More Link
add_filter( 'the_content_more_link', 'complete_more_link', 10, 2 );

function complete_more_link( $more_link, $more_link_text ) {
	return str_replace( $more_link_text, __('+ Read More', 'picart'), $more_link );
}

//complete CUSTOM Search Form
function complete_search_form( $form ) {
    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <div>
    <input placeholder="' . __( 'Rechercher &hellip;', 'picart' ) . '" type="text" value="' . get_search_query() . '" name="s" id="s" />
    <input type="submit" id="searchsubmit" value="'. __( 'Rechercher', 'picart' ) .'" />
    </div>
    </form>';

    return $form;
}

add_filter( 'get_search_form', 'complete_search_form' );


//**************Tcomplete COMMENTS******************//
function complete_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">

     <div id="comment-<?php comment_ID(); ?>" class="comment-body">
     <div class="comm_edit"><?php edit_comment_link(__('Edit', 'picart'),'','') ?></div>
      
      
      <div class="comment-author vcard">
            <div class="avatar"><?php echo get_avatar($comment,$size='30' ); ?></div>
            <div class="comm_auth"><?php printf(__('%s', 'picart'), get_comment_author_link()) ?></div>
            <a class="comm_date"><i class="fa-clock-o"></i><?php echo human_time_diff( get_comment_time('U'), current_time('timestamp') ) . ' ago'; ?></a>
            
            <div class="comm_reply">
              <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'], 'before' =>'<i class="fa-reply"></i> '))) ?>
            </div>
        
      </div>
      
      
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('Your comment is awaiting moderation.', 'picart') ?></em>
         <br />
      <?php endif; ?>

      <div class="org_comment"><?php comment_text() ?></div>
     
     </div>
<?php
        }
		
//**************TRACKBACKS & PINGS******************//
function complete_ping($comment, $args, $depth) {
 
$GLOBALS['comment'] = $comment; ?>
	
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
   
     <div id="comment-<?php comment_ID(); ?>" class="comment-body">
           <?php edit_comment_link(__('Edit', 'picart'),'  ','') ?>
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('Your comment is awaiting moderation.', 'picart') ?></em>
         <br />
      <?php endif; ?>

      <div class="org_ping">
      	<?php printf(__('<cite class="citeping">%s</cite> <span class="says">:</span>', 'picart'), get_comment_author_link()) ?>
	  	<?php comment_text() ?>
            <div class="comm_meta_reply">
            <div class="comm_date"><i class="fa-clock-o"></i><?php echo human_time_diff( get_comment_time('U'), current_time('timestamp') ) . ' ago'; ?></div>
            </div>
     </div>
     </div>
     

<?php }


//COMMENT FORM DEFAULT FIELDS
function complete_comment_form_fields($fields){
	$commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
    global $picart;
	
	$fields['author'] = '<div class="comm_wrap"><p class="comment-form-author"><input placeholder="' . __( 'Name', 'picart' ) . '" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .'" size="30"' . $aria_req . ' /></p>';

	$fields['email'] = '<p class="comment-form-email"><input placeholder="' . __( 'Email', 'picart' ) . '" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .'" size="30"' . $aria_req . ' /></p>';

	$fields['url'] = '<p class="comment-form-url"><input placeholder="' . __( 'Website', 'picart' ) . '" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .'" size="30" /></p></div>';
    return $fields;
}

add_filter('comment_form_default_fields','complete_comment_form_fields');